{$DeskAcc -1 -1 'Four Puzzle' }
{$LongGlobals+}

program FourPuzzle;

{ TML Pascal 1.5 source for "Four Puzzle" NDA, originally based
  on the Puzzle in the TML Source Code Library.  Not much of the
  original code is left.

  by David A. Lyons 
  
  Originally written in August, 1987.
  Modified 26-Jun-88 DAL
    --source code cleaned up a lot
    --Undo (menu & Apple-Z) is supported
    --I/J/K/M work

  Watch for ShareWare from:
    DAL Systems
    P.O. Box 287
    North Liberty, IA 52317
    [CompuServe 72177,3233]
    [GEnie mail   D.LYONS2]
 }

uses
  QDIntf, GSIntf, MiscTools;

const
  PuzzleSizeM1 = 3;  { MUST be PuzzleSize MINUS ONE }
  PuzzleSize   = 4;  { just change these constants to make
                       different sizes of puzzles! (Change
                       the things name to something other
                       that "Four Puzzle" if you do!) }

var     myWindOpen:  boolean;
        myWind:      NewWindowParamBlk;
        myWindPtr:   WindowPtr;
        CurrentlySolved: boolean;
        UndoCol, UndoRow: integer;

    puzzle:  array[0..PuzzleSizeM1,0..PuzzleSizeM1] of 
                 record
                   num: integer;
                   r:   rect;
                end;
    EmptyCol, EmptyRow: integer;


{ Copy description info onto the Clipboard! }
procedure DoInfo;
const
  NumL = 9;
var
  return: char;
  i: integer;
  myStr: array[1..NumL] of String[55];
begin
  return := char(13);
  if (ScrapStatus<>0) and (ToolErrorNum=0) then begin
    myStr[1] := 'Four Puzzle v2.0--public domain, by';
    myStr[2] := 'David A. Lyons.  Watch for Shareware';
    myStr[3] := 'from:';
    myStr[4] := '';
    myStr[5] := '   DAL Systems';
    myStr[6] := '   P.O. Box 287';
    myStr[7] := '   North Liberty, IA 52317';
    myStr[8] := '   [CompuServe 72177,3233]';
    myStr[9]:=  '   [GEnie mail   D.LYONS2]';
    ZeroScrap;
    for i := 1 to NumL do begin
      PutScrap(length(myStr[i]),0,@myStr[i][1]);
      PutScrap(1,0,@return);
    end;
  end;
end; { DoInfo }

{ --------- DA specific routines declared forward ---------- }

procedure DrawPuzzle;                                forward;
procedure DoMouseDown(theEvent: EventRecord);        forward;
procedure DoKeyDown(theEvent: EventRecord);          forward;
procedure ClickedIn(i,j: integer);                   forward;

{ "Undo" in a N-puzzle means to Click in the location that
  *was* empty before the last operation.  UndoCol and UndoRow
  record that location.  If UndoRow is -1, no undoing is
  allowed.  This will be the case right after the puzzle has
  been scrambled (because Clear was chosen, because the puzzle
  was just opened, or because the puzzle was just rescrambled
  after being solved).  UndoRow is also -1 when the puzzle
  is in a solved state; it will be rescrambled on the next
  KeyDown or MouseDown event. }
procedure DoUndo;
var
  OldPort: WindowPtr;
begin
  OldPort := GetPort;
  SetPort(myWindPtr);
  if UndoCol<>-1 then
    ClickedIn(UndoCol,UndoRow)
  else
    SysBeep;
  SetPort(OldPort);
end;

procedure MoveUp(c,r: integer);
begin
  puzzle[c,r-1].num := puzzle[c,r].num;
  puzzle[c,r].num := 0;
  inc(EmptyRow);
end;

procedure MoveDown(c,r: integer);
begin
  puzzle[c,r+1].num := puzzle[c,r].num;
  puzzle[c,r].num := 0;
  dec(EmptyRow);
end;

procedure MoveLeft(c,r: integer);
begin
  puzzle[c-1,r].num := puzzle[c,r].num;
  puzzle[c,r].num := 0;
  inc(EmptyCol);
end;

procedure MoveRight(c,r: integer);
begin
  puzzle[c+1,r].num := puzzle[c,r].num;
  puzzle[c,r].num := 0;
  dec(EmptyCol);
end;

procedure ScrambleIt;
VAR
  Count: integer;
  PrevDir, Dir: integer;
begin
  CurrentlySolved := false;
  UndoRow := -1;  UndoCol := -1;
  Dir := -1;
  for Count := 1 to 350 do begin
    PrevDir := Dir;
    repeat
      Dir := Random mod 4
    until Dir <> 3-PrevDir;  { Don't take back any moves }
    case Dir of
      0: if EmptyCol>0 then
           MoveRight(EmptyCol-1,EmptyRow);
      3: if EmptyCol<PuzzleSizeM1 then
           MoveLeft(EmptyCol+1,EmptyRow);
      2: if EmptyRow>0 then
           MoveDown(EmptyCol,EmptyRow-1);
      1: if EmptyRow<PuzzleSizeM1 then
           MoveUp(EmptyCol,EmptyRow+1);
    end;
  end;
end;

function CheckSolved: boolean;
var
  i,j,temp: integer;
  Solved: boolean;
begin
  Solved := true;
  temp := puzzle[EmptyCol,EmptyRow].num;
  puzzle[EmptyCol,EmptyRow].num := PuzzleSize*PuzzleSize;
  for I := 0 to PuzzleSizeM1 do
    for J := 0 to PuzzleSizeM1 do
      if puzzle[i,j].num <> J*PuzzleSize+I+1 then Solved := false;
  CheckSolved := Solved;
  puzzle[EmptyCol,EmptyRow].num := temp;
end;

procedure IsSolved;
var
  i: integer;
  r: rect;
  t1: longint;
begin
  UndoRow := -1;  UndoCol := -1;
  SysBeep; SysBeep;  SysBeep;
  SetRect(r,0,0,1000,1000);
  for i := 1 to 20 do begin
    InvertRect(r);
    t1 := TickCount+2;
    repeat until TickCount>t1;
  end;
  CurrentlySolved := true;
end;

{ --------- The 4 required NDA routines ---------- }

function DAOpen: WindowPtr;
var
  Col, Row: integer;
  RomFontInfo: record
    Family, Style, Size: integer;
    fHand:  handle;
    NamePtr: ptr;
    extent: integer;
    x1, x2, x3, x4, x5: integer; { room for expansion? }
  end;
  oldPort: WindowPtr;
begin
  if myWindOpen then exit;
  fillchar(myWind,sizeof(NewWindowParamBlk),0);
  with myWind do begin
    param_length := sizeof(NewWindowParamBlk);
    wFrame       := $C0A0;
    wTitle       := @'Puzzle (Lyons)';
    SetRect(wPosition,0,0,45*PuzzleSize+1,15*PuzzleSize+1);
    OffsetRect(wPosition,50,40);
    wPlane       := -1;
  end;
  myWindPtr := NewWindow(myWind);
  DAOpen    := myWindPtr;
  SetSysWindow(myWindPtr);
  myWindOpen := true;

  { Initialize my puzzle array }
  for Row := 0 TO PuzzleSizeM1 do
    for Col := 0 TO PuzzleSizeM1 do begin
      puzzle[Col,Row].num := Row*PuzzleSize + Col+1;
      SetRect(puzzle[Col,Row].r,
         1 + Col * 45,
         1 + Row * 15,
         1 + Col * 45 + 43,
         1 + Row * 15 + 14 );
    end;
  puzzle[PuzzleSizeM1,PuzzleSizeM1].num := 0;
  EmptyRow := PuzzleSizeM1;
  EmptyCol := PuzzleSizeM1;
  ScrambleIt;
  
  { Set font of our window to the ROM font in case somebody
    has changed the System Font to something big which won't
    fit into the little rectangles. } 
  oldPort := GetPort;
  SetPort(myWindPtr);
  GetRomFont(@RomFontInfo);
  SetFont(RomFontInfo.fHand);
  SetPort(oldPort);
end; { of DAOpen }

procedure DAClose;
begin
  if myWindOpen then CloseWindow(myWindPtr);
  myWindOpen := false;
end; { of DAClose }

procedure DAAction(Code: Integer; Param: EventRecordPtr);
var
  currPort: GrafPtr;
  what: Integer;
  modifiers: Integer;
  key: char;
begin
  case Code of
    DAEvent: begin
      currPort := GetPort;
      SetPort(myWindPtr);
      what := EventRecordPtr(param)^.what;
      case what of
        updateEvt: begin
            BeginUpdate(myWindPtr);
            DrawPuzzle;
            EndUpdate(myWindPtr);
          end;
        activateEvt: { nothing for this DA } ;
        keyDown, autoKey: begin
            if bitand(param^.modifiers,AppleKey)<>0 then begin
              key := chr(loword(EventRecordPtr(param)^.message));
              case key of
                'x', 'X',
                'c', 'C': DoInfo;
                'z', 'Z': DoUndo;
                otherwise SysBeep;
              end;
            end else begin { not Apple key }
              if CurrentlySolved then begin
                ScrambleIt;
                DrawPuzzle;
              end;
              DoKeyDown(param^);
            end; { not Apple key }
          end;
        mouseDown: begin
            if CurrentlySolved then begin
              ScrambleIt;
              DrawPuzzle;
            end;
            DoMouseDown(param^);
          end;
        end; { case event }
        SetPort(currPort);
      end;
      DARun:    ;
      DACursor: ;
      DAUndo:   begin
          DoUndo;
          Code := 1;
        end;
      DACut,
      DACopy:   begin DoInfo; Code := 1; end;
      DAPaste:  code := 1;
      DAClear:  begin
         currPort := GetPort;
         SetPort(GrafPtr(myWindPtr));
         ScrambleIt; DrawPuzzle;
         Code := 1;
         SetPort(currPort);
        end;
   end;
end; { of DAAction }

procedure DAInit(Code: Integer);
begin
   if Code = 0 then begin
      { A DeskShutDown Call, chk that my window is closed }
      if myWindOpen then DAClose;
   end else begin
      { A DeskStartUp Call, init myWindOpen flag }
      myWindOpen := false;
   end;
end; { of DAInit }

{ --------- DA specific routines ---------- }

procedure UpdateBox(i,j: integer);
var
  Char1: char;
begin
  with puzzle[i,j] do begin
     if num <> 0 then begin
        FrameRect(r);
        InsetRect(r,1,1); EraseRect(r); InsetRect(r,-1,-1);
        MoveTo(r.left+14, r.top+10);
        Char1 := ' ';
        if num>9 then Char1 := chr(ord('0')+(num div 10));
        DrawChar(Char1);
        DrawChar(chr(ord('0')+(num MOD 10)));
     end { <> 0 }
     else
        EraseRect(r);
  end { of with }
end; { of UpdateBox }

procedure DrawPuzzle;
var
  i,j: Integer;
begin
   for i := 0 to PuzzleSizeM1 do
      for j := 0 to PuzzleSizeM1 do 
         UpdateBox(i,j);
end; { of DrawPuzzle }


procedure ClickedIn(i,j: integer);
var
  r,c: integer;
begin
   if i=EmptyCol then begin
     UndoRow := EmptyRow;  UndoCol := EmptyCol;
     if j < EmptyRow then
       for r := EmptyRow-1 downto j do MoveDown(i,r)
     else if j > EmptyRow then
       for r := EmptyRow+1 to j do MoveUp(i,r);
     for r := 0 to PuzzleSizeM1 do UpdateBox(i,r)
   end else if j=EmptyRow then begin
     UndoRow := EmptyRow;  UndoCol := EmptyCol;
     if i < EmptyCol then
       for c := EmptyCol-1 downto i do MoveRight(c,j)
     else if i > EmptyCol then
       for c := EmptyCol+1 to i do MoveLeft(c,j);
     for c := 0 to PuzzleSizeM1 do UpdateBox(c,j);
   end
end;

procedure DoKeyDown(theEvent: EventRecord);
var
  OldCol, OldRow: integer;
begin
  OldCol := EmptyCol;
  OldRow := EmptyRow;
  case LoWord(theEvent.message) OF
     8, 74, 106:  { left, J, j }
      if EmptyCol<PuzzleSizeM1 then MoveLeft(EmptyCol+1,EmptyRow);
    21, 75, 107: { right, K, k }
      if EmptyCol>0 then MoveRight(EmptyCol-1,EmptyRow);
    10, 77, 109: { down, M, m }
      if EmptyRow>0 then MoveDown(EmptyCol,EmptyRow-1);
    11, 73, 105: { up, I, i }
      if EmptyRow<PuzzleSizeM1 then MoveUp(EmptyCol,EmptyRow+1);
  end;
  UpdateBox(OldCol,OldRow);
  UpdateBox(EmptyCol,EmptyRow);
  if CheckSolved then
    IsSolved
  else begin
    UndoCol := OldCol;
    UndoRow := OldRow;
  end;
end;

procedure DoMouseDown(theEvent: EventRecord);
var
  i,j: integer;
begin
   GlobalToLocal(theEvent.where);
   repeat
     for i := 0 to PuzzleSizeM1 do
        for j := 0 to PuzzleSizeM1 do
           with puzzle[i,j] do
              if PtInRect(theEvent.where,r) and (num<>0)  then begin
                ClickedIn(i,j);
                if CheckSolved then begin
                    IsSolved;
                    repeat until not Button(0);
                  end;
              end;
      GetMouse(theEvent.where);
    until not Button(0);
end; { of DoMouseDown }

begin
   { no main program; the DAxxx procedures are called directly }
end.
